<?php

/**
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * @author      Elmar Ludwig
 * @author      Ron Lucke
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GPL version 2
 */

class AssistantController extends PluginController
{
    /**
     * Callback function being called before an action is executed.
     */
    public function before_filter(&$action, &$args)
    {
        parent::before_filter($action, $args);

        $this->course_id = Context::getId();

        if (!$GLOBALS['perm']->have_studip_perm('tutor', $this->course_id)) {
            throw new AccessDeniedException();
        }
    }

    /**
     * Default action: show the tool assistant.
     */
    public function index_action()
    {
        Navigation::activateItem('/course/assistant');
        PageLayout::setTitle(Context::getHeaderLine() . ' - Service & Support');
        PageLayout::addStylesheet($this->plugin->getPluginURL() . '/assets/assistant.css?v=0.1');

        $widget = new SidebarWidget();
        $widget->setTitle('Service & Support');
        $widget->addElement(new WidgetElement($this->_(
            'Die Universität Osnabrück bietet über virtUOS und Rechenzentrum viele Möglichkeiten, Lehre online zu unterstützen. ' .
            'Für die hier vorgestellten Tools sind verlässlicher Betrieb und persönlicher Support gewährleistet und sie ' .
            'ermöglichen eine datenschutzrechtlich unbedenkliche Nutzung.<br><br> ' .
            'Auf dieser Seite finden Sie nicht nur erste Informationen, sondern können weitere Schritte direkt von hier aus starten.'))
        );
        $widget->addElement(new WidgetElement(Studip\LinkButton::create($this->_('"Spickzettel" herunterladen'), $this->plugin->getPluginURL().'/assets/spickzettel-digitale-lehre.pdf')));
        Sidebar::get()->addWidget($widget);

        $this->course = Course::find($this->course_id);
        $this->datafields = DataFieldEntry::getDataFieldEntries($this->course_id, 'sem');
        $this->folder_id = Folder::findTopFolder($this->course_id)->id;
    }

    public function set_type_action()
    {
        CSRFProtection::verifyUnsafeRequest();

        $df = Request::getArray('df');
        $id = 'aee5626da96ab9c37976b2fc454d88b4';
        $datafields = DataFieldEntry::getDataFieldEntries($this->course_id, 'sem');

        $datafields[$id]->setValueFromSubmit($df[$id]);

        if ($datafields[$id]->isValid() && $datafields[$id]->isEditable() && !LockRules::Check($this->course_id, $id)) {
            $datafields[$id]->store();
        }

        PageLayout::postSuccess($this->_('Die Einstellungen für die Veranstaltungsform wurden gespeichert'));

        $this->redirect('assistant');
    }

    public function sem_format_info_action()
    {
    }

    public function mail_info_action($view = 'example')
    {
        $this->view = $view;
    }

    public function recording_info_action($view = 'example')
    {
        $this->view = $view;
    }

    public function vips_info_action($view = 'example')
    {
        $this->view = $view;
    }

    public function courseware_action()
    {
        $plugin_manager = PluginManager::getInstance();
        $courseware = $plugin_manager->getPlugin('CoursewareModule');
        $plugin_manager->setPluginActivated($courseware->getPluginId(), $this->course_id, true);

        $this->redirect(URLHelper::getURL('dispatch.php/course/courseware'));
    }

    public function opencast_action()
    {
        $plugin_manager = PluginManager::getInstance();
        $opencast = $plugin_manager->getPlugin('OpenCast');
        $plugin_manager->setPluginActivated($opencast->getPluginId(), $this->course_id, true);

        $this->redirect(PluginEngine::getURL($opencast, [], '/course/create_series'));
    }

    public function vips_action()
    {
        $plugin_manager = PluginManager::getInstance();
        $vips = $plugin_manager->getPlugin('VipsPlugin');
        $plugin_manager->setPluginActivated($vips->getPluginId(), $this->course_id, true);

        $example = file_get_contents($this->plugin->getPluginPath() . '/assets/vips-example.xml');
        $assignment = VipsAssignment::importXML($example, $GLOBALS['user']->id, $this->course_id);
        $this->redirect(PluginEngine::getURL($vips, [], 'sheets'));
    }

    public function meetings_action()
    {
        $plugin_manager = PluginManager::getInstance();
        $meetings = $plugin_manager->getPlugin('MeetingPlugin');
        $plugin_manager->setPluginActivated($meetings->getPluginId(), $this->course_id, true);

        $this->redirect(URLHelper::getURL('plugins.php/meetingplugin/index'));
    }

    public function schedule_action()
    {
        $plugin_manager = PluginManager::getInstance();
        $schedule = $plugin_manager->getPlugin('CoreSchedule');
        $plugin_manager->setPluginActivated($schedule->getPluginId(), $this->course_id, true);

        $this->redirect(URLHelper::getURL('dispatch.php/course/dates'));
    }
}
